package immibis.core.microblock.recipes;

import immibis.core.microblock.CoverSystemProxy;

import java.util.HashMap;

import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public class RecipeHollowCover implements IRecipe {
	
	private static HashMap<Integer, Integer> damageMap = new HashMap<Integer, Integer>();
	
	public static void addMap(int a, int b)
	{
		damageMap.put(a, b);
	}

	@Override
	public boolean matches(InventoryCrafting i, World world) {
		return getCraftingResult(i) != null;
	}

	@Override
	public ItemStack getCraftingResult(InventoryCrafting i) {
		if(i.getSizeInventory() != 9)
			return null;
		int slot = -1;
		int damage = -1;
		for(int k = 0; k < 9; k++)
		{
			ItemStack is = i.getStackInSlot(k);
			if(k == 4) {
				if(is != null)
					return null;
			} else if(is == null) {
				return null;
			} else if(is.itemID != CoverSystemProxy.blockMultipart.blockID) {
				return null;
			} else if(damage == -1) {
				damage = is.getItemDamage();
			} else if(damage != is.getItemDamage()) {
				return null;
			}
		}
		Integer o = damageMap.get(damage);
		if(o == null) {
			System.out.println("no damage map");
			return null;
		}
		return new ItemStack(CoverSystemProxy.blockMultipart.blockID, 8, o.intValue());
	}

	@Override
	public int getRecipeSize() {
		return 3;
	}

	@Override
	public ItemStack getRecipeOutput() {
		return new ItemStack(CoverSystemProxy.blockMultipart, 1, 0);
	}

}
