package immibis.core.microblock.recipes;

import immibis.core.microblock.CoverSystemProxy;

import java.util.HashMap;

import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public class RecipeCombineTwo implements IRecipe {

	private static HashMap<Integer, Integer> damageMap = new HashMap<Integer, Integer>();
	
	public static void addMap(int a, int b)
	{
		damageMap.put(a, b);
	}
	
	@Override
	public boolean matches(InventoryCrafting var1, World var2) {
		return getCraftingResult(var1) != null;
	}

	@Override
	public ItemStack getCraftingResult(InventoryCrafting var1) {
		ItemStack first = null, second = null;
		for(int k = 0; k < var1.getSizeInventory(); k++) {
			ItemStack is = var1.getStackInSlot(k);
			if(is != null) {
				if(is.itemID != CoverSystemProxy.blockMultipart.blockID)
					return null;
				
				if(first == null)
					first = is;
				else if(second == null)
					second = is;
				else
					return null;
			}
		}
		
		if(second == null)
			return null;
		
		if(first.getItemDamage() != second.getItemDamage())
			return null;
		
		Integer newDamage = damageMap.get(first.getItemDamage());
		
		if(newDamage == null)
			return null;
		
		return new ItemStack(first.itemID, 1, newDamage);
		
	}

	@Override
	public int getRecipeSize() {
		return 2;
	}

	@Override
	public ItemStack getRecipeOutput() {
		return new ItemStack(CoverSystemProxy.blockMultipart, 1, 0);
	}

}
