package immibis.core.microblock;



import java.util.List;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;

public class TileMultipart extends TileEntity implements ICoverableTile {
	public CoverImpl cover;
	
	public TileMultipart() {
		cover = new CoverImpl(this);
	}
	
	@Override
	public final Packet getDescriptionPacket() {
		NBTTagCompound tag = new NBTTagCompound();
		tag.setByteArray("C", cover.writeDescriptionBytes());
		return new Packet132TileEntityData(xCoord, yCoord, zCoord, 0, tag);
	}
	
	@Override
	public void onDataPacket(INetworkManager net, Packet132TileEntityData pkt) {
		cover.readDescriptionBytes(pkt.customParam1.getByteArray("C"), 0);
	}

	@Override
	public CoverImpl getCoverImpl() {
		return cover;
	}
	
	@Override
	public void writeToNBT(NBTTagCompound tag) {
		super.writeToNBT(tag);
		cover.writeToNBT(tag);
	}
	
	@Override
	public void readFromNBT(NBTTagCompound tag) {
		super.readFromNBT(tag);
		cover.readFromNBT(tag);
	}

	@Override
	public boolean isPlacementBlockedByTile(PartType type, EnumPosition pos) {
		return false;
	}
	
	@Override
	public boolean isPositionOccupiedByTile(EnumPosition pos) {
		return false;
	}
	
	@Override
	public void updateEntity() {
		if(getClass() == TileMultipart.class && cover.parts.size() == 0) {
			worldObj.setBlockWithNotify(xCoord, yCoord, zCoord, 0);
		}
	}

	@Override
	public MovingObjectPosition collisionRayTrace(Vec3 src, Vec3 dst) {
		return null;
	}

	@Override
	public EnumPosition getPosition(int subHit) {
		return null;
	}

	@Override
	public AxisAlignedBB getAABBFromPool(int subHit) {
		return null;
	}

	@Override
	public void getCollidingBoundingBoxes(AxisAlignedBB mask,
			List<AxisAlignedBB> list) {
		// TODO Auto-generated method stub
		
	}
}
