package immibis.core.api;

import immibis.core.ImmibisCore;
import immibis.core.api.net.INetworkingManager;

/**
 * Contains methods to get instances of various API interfaces.
 * Note: for mods that do not specify ImmibisCore as a required dependency,
 * this class may not be present, so calls to it should be wrapped in try-catch
 * blocks to catch NoClassDefFoundError errors.
 *
 */
public final class APILocator {
	public static IIDAllocator getIDAllocator() {
		return ImmibisCore.idAllocator;
	}
	public static INetworkingManager getNetManager() {
		return ImmibisCore.networkingManager;
	}
}
