package immibis.chunkloader;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.src.ModLoader;

import org.lwjgl.opengl.GL11;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

@SideOnly(Side.CLIENT)
public class GuiAnchor extends GuiContainer {
	private ContainerChunkLoader container;
	private GuiButton serverOwnerButton;
	
	public GuiAnchor(ContainerChunkLoader container) {
		super(container);
		this.container = container;
		xSize = 186;
		ySize = 116;
	}
	
	@Override
	public void initGui() {
		super.initGui();
		
		controlList.clear();
		
		serverOwnerButton = new GuiButton(0, guiLeft + 6, guiTop + 87, 113, 20, "");
		controlList.add(serverOwnerButton);
	}

	@Override
	protected void drawGuiContainerBackgroundLayer(float var1, int mouseX, int mouseY) {
		int k = mc.renderEngine.getTexture("/immibis/chunkloader/gui.png");
        GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
        mc.renderEngine.bindTexture(k);
        int l = (width - xSize) / 2;
        int i1 = (height - ySize) / 2;
        drawTexturedModalRect(l, i1, 0, 0, xSize, ySize);
        
        ContainerChunkLoader cont = (ContainerChunkLoader)inventorySlots;
        
        controlList.clear();
        if(cont.amIOp)
        {
        	serverOwnerButton.displayString = cont.tile.isServerOwned ? "Set owner to you" : "Set owner to server";
        	controlList.add(serverOwnerButton);
        }
	}

	@Override
	protected void actionPerformed(GuiButton button)
	{
		if(button == serverOwnerButton && ((ContainerChunkLoader)inventorySlots).amIOp)
			container.sendButtonPressed(5);
	}
	
	@Override
	protected void mouseClicked(int real_x, int real_y, int button)
    {
		int x = (real_x - this.guiLeft);
		int y = (real_y - this.guiTop);
		if(button == 0)
		{
			if(x >= 124 && y >= 85 && x <= 147 && y <= 108)
				// decrease size button
				container.sendButtonPressed(3);
			else if(x >= 153 && y >= 85 && x <= 176 && y <= 108)
				// increase size button
				container.sendButtonPressed(4);
			else
				super.mouseClicked(real_x, real_y, button);
		}
		else
			super.mouseClicked(real_x, real_y, button);
    }
	
	@Override
	protected void drawGuiContainerForegroundLayer(int p1, int p2) {
        TileChunkLoader tile = ((ContainerChunkLoader)inventorySlots).tile;
        ContainerChunkLoader cont = (ContainerChunkLoader)inventorySlots;
        
        Minecraft mc = ModLoader.getMinecraftInstance();
        
        if(!mc.theWorld.isRemote)
        	cont.updateFields();
        
        fontRenderer.drawString("Owner: " + (tile.isServerOwned ? "(server)" : tile.owner), 6, 6, 0x404040);
        
        if(cont.ownedByMe || cont.amIOp) {
        	int limit = cont.getMaxQuota();
        	if(!tile.isServerOwned)
        	{
        		String limitStr = (limit == -1 ? "" : limit == -2 ? "unlimited" : "" + limit);
        		fontRenderer.drawString((cont.ownedByMe ? "Your" : "Their") + " chunk limit: " + cont.getCurQuota() + " / " + limitStr, 6, 16, 0x404040);
        	}
        	int area = tile.radius*2+1;
        	if(area > 0)
        		fontRenderer.drawString("Area: " + area + "x" + area, 6, 36, 0x404040);
        	else
        		fontRenderer.drawString("Area: None", 6, 36, 0x404040);
        	
        	//if(!cont.ownedByMe) {
        		fontRenderer.drawString("Only ops and owner can see this.", 6, 46, 0x404040);
        	//}
        }
	}
}
