package immibis.chunkloader;

import immibis.core.api.APILocator;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.EntityLiving;
import net.minecraft.src.ModLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;

import org.lwjgl.opengl.GL11;

import cpw.mods.fml.client.registry.KeyBindingRegistry;
import cpw.mods.fml.client.registry.KeyBindingRegistry.KeyHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

@SideOnly(Side.CLIENT)
public class ClientProxy extends BaseProxy
{
	private KeyBinding seeChunksKey;
	
	@ForgeSubscribe
	public void onRWL(net.minecraftforge.client.event.RenderWorldLastEvent evt) {
		onRenderWorldLast(evt.context, evt.partialTicks);
	}
	
	@Override
	public void load() {
		seeChunksKey = new KeyBinding("Show force-loaded chunks", org.lwjgl.input.Keyboard.KEY_F9);
		
		MinecraftForge.EVENT_BUS.register(this);
		KeyBindingRegistry.registerKeyBinding(new KeyHandler(new KeyBinding[] {seeChunksKey}, new boolean[] {false}) {
			
			@Override
			public String getLabel() {
				// TODO Auto-generated method stub
				return null;
			}
			
			@Override
			public EnumSet<TickType> ticks() {
				return EnumSet.of(TickType.RENDER);
			}
			
			@Override
			public void keyUp(EnumSet<TickType> types, KeyBinding kb, boolean tickEnd) {
			}
			
			@Override
			public void keyDown(EnumSet<TickType> types, KeyBinding kb, boolean tickEnd, boolean isRepeat) {
				if(tickEnd)
					keyboardEvent(kb);
			}
		});
	}
	
	@Override
	public void keyboardEvent(Object key) {
		if(key == seeChunksKey) {
			showingChunks = !showingChunks;
			if(showingChunks) {
				APILocator.getNetManager().sendToServer(new PacketShowChunksRequest());
			} else {
				loadedChunkDisplays = null;
				loaderDisplays = null;
			}
		}
	}
	
	@SideOnly(Side.CLIENT)
	public void onRenderWorldLast(RenderGlobal rg, float partialTicks) {
		if(loadedChunkDisplays == null)
			return;
		
		if(loaderDisplays == null) {
			loaderDisplays = new HashMap<WorldInfo.XYZ, Boolean>();
			for(LoadedChunkDisplay lcd : loadedChunkDisplays) {
				loaderDisplays.put(new WorldInfo.XYZ(lcd.loaderX, lcd.loaderY, lcd.loaderZ), lcd.isOwned);
			}
		}
		
		Minecraft mc = ModLoader.getMinecraftInstance();
		EntityLiving rve = mc.renderViewEntity;
		
		GL11.glDisable(GL11.GL_TEXTURE_2D);
		GL11.glDisable(GL11.GL_DEPTH_TEST);
		GL11.glDisable(GL11.GL_CULL_FACE);
		GL11.glEnable(GL11.GL_BLEND);
		GL11.glPushMatrix();
		GL11.glTranslated(
				-(rve.lastTickPosX + (rve.posX - rve.lastTickPosX) * partialTicks),
				-(rve.lastTickPosY + (rve.posY - rve.lastTickPosY) * partialTicks),
				-(rve.lastTickPosZ + (rve.posZ - rve.lastTickPosZ) * partialTicks));
		Tessellator t = Tessellator.instance;
		
		
		// a fixed distance above the player
		double y = (rve.lastTickPosY + (rve.posY - rve.lastTickPosY) * partialTicks) + 20;
		
		t.startDrawingQuads();
		t.setColorRGBA(255, 0, 0, 80);
		for(LoadedChunkDisplay lcd : loadedChunkDisplays) {
			double x = lcd.chunkX * 16;
			double z = lcd.chunkZ * 16;
			t.addVertex(x, y, z);
			t.addVertex(x+16, y, z);
			t.addVertex(x+16, y, z+16);
			t.addVertex(x, y, z+16);
		}
		t.setColorRGBA(0, 255, 255, 80);
		for(Map.Entry<WorldInfo.XYZ, Boolean> e : loaderDisplays.entrySet()) {
			WorldInfo.XYZ xyz = e.getKey();
			double x = xyz.x;
			double y_ = xyz.y;
			double z = xyz.z;
			if(e.getValue() == Boolean.TRUE)
				// owned by you
				t.setColorRGBA(0, 127, 255, 80);
			else
				// owned by someone else
				t.setColorRGBA(255, 127, 0, 80);
			t.addVertex(x+0, y_+0, z+0);
			t.addVertex(x+0, y_+1, z+0);
			t.addVertex(x+1, y_+1, z+0);
			t.addVertex(x+1, y_+0, z+0);
			
			t.addVertex(x+0, y_+0, z+1);
			t.addVertex(x+0, y_+1, z+1);
			t.addVertex(x+1, y_+1, z+1);
			t.addVertex(x+1, y_+0, z+1);
			
			t.addVertex(x+1, y_+0, z+0);
			t.addVertex(x+1, y_+0, z+1);
			t.addVertex(x+0, y_+0, z+1);
			t.addVertex(x+0, y_+0, z+0);
			
			t.addVertex(x+0, y_+1, z+0);
			t.addVertex(x+1, y_+1, z+0);
			t.addVertex(x+1, y_+1, z+1);
			t.addVertex(x+0, y_+1, z+1);
			
			t.addVertex(x+0, y_+0, z+0);
			t.addVertex(x+0, y_+1, z+0);
			t.addVertex(x+0, y_+1, z+1);
			t.addVertex(x+0, y_+0, z+1);
			
			t.addVertex(x+1, y_+0, z+0);
			t.addVertex(x+1, y_+1, z+0);
			t.addVertex(x+1, y_+1, z+1);
			t.addVertex(x+1, y_+0, z+1);
		}
		t.draw();
		
		GL11.glEnable(GL11.GL_DEPTH_TEST);
		
		double bottom = 0;
		
		t.startDrawing(GL11.GL_LINES);
		t.setColorRGBA(0, 255, 0, 80);
		GL11.glLineWidth(2);
		for(LoadedChunkDisplay lcd : loadedChunkDisplays) {
			double x = lcd.chunkX * 16;
			double z = lcd.chunkZ * 16;
			t.addVertex(x, y, z);
			t.addVertex(x, bottom, z);
			t.addVertex(x+16, y, z);
			t.addVertex(x+16, bottom, z);
			t.addVertex(x+16, y, z+16);
			t.addVertex(x+16, bottom, z+16);
			t.addVertex(x, y, z+16);
			t.addVertex(x, bottom, z+16);
		}
		t.draw();
		
		t.startDrawingQuads();
		t.setColorRGBA(0, 0, 255, 40);
		for(LoadedChunkDisplay lcd : loadedChunkDisplays) {
			if(lcd.chunkX != rve.chunkCoordX || lcd.chunkZ != rve.chunkCoordZ)
				continue;
			double x = lcd.chunkX * 16;
			double z = lcd.chunkZ * 16;
			t.addVertex(x, y, z);
			t.addVertex(x, bottom, z);
			t.addVertex(x+16, bottom, z);
			t.addVertex(x+16, y, z);
			t.addVertex(x, y, z+16);
			t.addVertex(x, bottom, z+16);
			t.addVertex(x+16, bottom, z+16);
			t.addVertex(x+16, y, z+16);
			t.addVertex(x, y, z);
			t.addVertex(x, bottom, z);
			t.addVertex(x, bottom, z+16);
			t.addVertex(x, y, z+16);
			t.addVertex(x+16, y, z);
			t.addVertex(x+16, bottom, z);
			t.addVertex(x+16, bottom, z+16);
			t.addVertex(x+16, y, z+16);
			break;
		}
		t.draw();
		
		GL11.glPopMatrix();
		GL11.glDisable(GL11.GL_BLEND);
		GL11.glEnable(GL11.GL_CULL_FACE);
		GL11.glEnable(GL11.GL_TEXTURE_2D);
	}
}

/* $endif$ */