package immibis.ars.beams.logictypes;

import java.util.HashSet;
import java.util.Set;

import net.minecraft.src.Entity;
import immibis.ars.beams.EntityFilter;
import immibis.ars.beams.LogicType;
import immibis.ars.beams.TileUpgradeUnit;

public class Negate extends LogicType {

	@Override
	public EntityFilter createFilter(TileUpgradeUnit container, final EntityFilter[] subfilters) {
		return new EntityFilter() {
			@Override
			public Set<Entity> filter(Set<Entity> in) {
				for(EntityFilter ef : subfilters)
					if(ef != null)
						in.removeAll(ef.filter(new HashSet<Entity>(in)));
				return in;
			}
		};
	}

}
