package immibis.ars.beams;

import immibis.core.api.Dir;

import java.util.Random;

import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Material;
import net.minecraft.src.ModLoader;
import net.minecraft.src.TileEntity;
import net.minecraft.src.World;

public class BlockBeam extends Block {
	
	public static final int MAX_LENGTH = 8;
	
	// metadata is direction

	public BlockBeam(int par1) {
		super(par1, 0, Material.vine); // Forge bug: must be a "ground cover" material or not replaceable.
		setTextureFile("/immibis/ars/textures/tesla.png");
		setBlockName("immibis.ars.beams.BlockBeam");
		setTickRandomly(true);
		
		ModLoader.addName(this, "Wireless data beam");
		ModLoader.registerBlock(this);
	}
	
	@Override
	public int getBlockTextureFromSideAndMetadata(int side, int meta) {
		if(meta < 6)
			return 0;
		else
			return 7;
	}
	
	//@Override
	//public boolean renderAsNormalBlock() {return false;}
	@Override
	public boolean isOpaqueCube() {return false;}
	@Override
	public AxisAlignedBB getCollisionBoundingBoxFromPool(World par1World, int par2, int par3, int par4) {
        return null;
    }
	
	public static int directionFromMetadata(int meta) {
		return meta % 6;
	}
	
	private void checkContinuity(World w, int x, int y, int z) {
		int meta = w.getBlockMetadata(x, y, z);
		int dir = directionFromMetadata(meta);
		int dx = 0, dy = 0, dz = 0;
		switch(dir) {
		case Dir.NX: dx = -1; break;
		case Dir.NY: dy = -1; break;
		case Dir.NZ: dz = -1; break;
		case Dir.PX: dx =  1; break;
		case Dir.PY: dy =  1; break;
		case Dir.PZ: dz =  1; break;
		}
		
		if(dx == 0 && dy == 0 && dz == 0) {
			// invalid metadata
			w.setBlockWithNotify(x, y, z, 0);
			return;
		}
		
		boolean ok = false;
		int prevX = x, prevY = y, prevZ = z;
		
		int length;
		
		for(length = 0; length < MAX_LENGTH; length++) {
			prevX -= dx;
			prevY -= dy;
			prevZ -= dz;
			// at prev must be another beam in the same direction, or an emitter
			if(w.getBlockId(prevX, prevY, prevZ) != blockID || w.getBlockMetadata(prevX, prevY, prevZ) != meta) {
				TileEntity te = w.getBlockTileEntity(prevX, prevY, prevZ);
				ok = (te instanceof TileBeamEmitter) && ((TileBeamEmitter)te).isOutputFace(dir);
				break;
			}
		}
		
		if(!ok)
			w.setBlockWithNotify(x, y, z, 0);
		else if(length < MAX_LENGTH - 1) {
			int nextX = x+dx;
			int nextY = y+dy;
			int nextZ = z+dz;
			if(nextY >= 0 && nextY < w.getHeight() && w.getBlockId(nextX, nextY, nextZ) == 0)
				w.setBlockAndMetadataWithNotify(nextX, nextY, nextZ, blockID, meta);
		}
	}
	
	@Override
	public boolean isBlockReplaceable(World w, int x, int y, int z) {
		return true;
	}
	
	@Override
	public void onNeighborBlockChange(World w, int x, int y, int z, int par5) {
		checkContinuity(w, x, y, z);
	}
	
	@Override
	public void onBlockAdded(World w, int x, int y, int z) {
		checkContinuity(w, x, y, z);
	}
	
	/*@Override
	public void updateTick(World w, int x, int y, int z, Random random) {
		// check that the beam is actually connected to an emitter
		// if not, delete it
		
		int myX = x, myY = y, myZ = z;
		
		
		
		if(!ok) {
			w.setBlock(myX, myY, myZ, 0);
		}
	}*/
	
	@Override
	public int getMobilityFlag() {
		return 2; // can't be pushed by pistons
	}
	
	@Override
	public int quantityDropped(int meta, int fortune, Random random) {
		return 0;
	}
	
	@Override
	public void setBlockBoundsBasedOnState(IBlockAccess world, int x, int y, int z) {
		int dir = directionFromMetadata(world.getBlockMetadata(x, y, z));
		
		final float min = 7/16.0f;
		final float max = 9/16.0f;
		
		if(dir == 0 || dir == 1)
			setBlockBounds(min, 0, min, max, 1, max);
		else if(dir == 2 || dir == 3)
			setBlockBounds(min, min, 0, max, max, 1);
		else if(dir == 4 || dir == 5)
			setBlockBounds(0, min, min, 1, max, max);
		else
			setBlockBounds(0, 0, 0, 1, 1, 1);
	}

}
