package immibis.ars.beams.logictypes;

import java.util.HashSet;
import java.util.Set;

import net.minecraft.src.Entity;
import net.minecraft.src.EntityCreeper;
import immibis.ars.beams.EntityFilter;
import immibis.ars.beams.LogicType;
import immibis.ars.beams.TileUpgradeUnit;

public class ClassDetector extends LogicType {
	
	public ClassDetector(Class<?> clazz) {
		this.clazz = clazz;
	}
	
	public Class<?> clazz;

	@Override
	public EntityFilter createFilter(TileUpgradeUnit container, EntityFilter[] in) {
		return new EntityFilter() {
			@Override
			public Set<Entity> filter(Set<Entity> in) {
				Set<Entity> rv = new HashSet<Entity>();
				for(Entity e : in)
					if(clazz.isAssignableFrom(e.getClass()))
						rv.add(e);
				return rv;
			}
		};
	}
}
