package immibis.ars;

import ic2.common.TileEntityNuclearReactor;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IInventory;
import net.minecraft.src.ItemStack;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.NBTTagList;
import net.minecraft.src.TileEntity;

public class TileEntityReaktorMonitor extends TileUpgradePassive implements IInventory {

	private ItemStack inventory[];
	private boolean channel[];
	private int targetheat[];
	private int RMonitor_ID;
	private boolean create;
	private int reaktorx;
	private int reaktory;
	private int reaktorz;
	private int heat;
	private boolean isreaktor;
	private boolean reaktoraktive;
	private int maxheat;
	private String Montorname = null;
	private int Montorname_ID = 0;
	
	@Override
	public int[] getUpdate() {
		return new int[] {heat, maxheat, targetheat[0], targetheat[1], targetheat[2], targetheat[3], targetheat[4], RMonitor_ID, Montorname_ID}; 
	}
	
	@Override
	public void handleUpdate(int[] p) {
		//System.out.println("monitor handleUpdate, heat is "+p[0]+"/"+p[1]);
		heat = p[0];
		maxheat = p[1];
		for(int k = 0; k < 5; k++)
			targetheat[k] = p[2+k];
		RMonitor_ID = p[7];
		Montorname_ID = p[8];
		Montorname = "Monitor@" + Montorname_ID;
	}
	
	@Override
	public void handleButton(int id) {
		switch (id) {

		case 0:
			if (getTargetheat(0) <= getMaxheat()) {
				setTargetheat(0, getTargetheat(0) + 100);
				if (getTargetheat(0) > getMaxheat()) {
					setTargetheat(0, getMaxheat());
				}
			}
			break;
		case 1:
			if (getTargetheat(0) >= 0) {
				setTargetheat(0, getTargetheat(0) - 100);
				if (getTargetheat(0) < 0) {
					setTargetheat(0, 0);
				}
			}
			break;
		case 2:
			if (getTargetheat(1) <= getMaxheat()) {
				setTargetheat(1, getTargetheat(1) + 100);
				if (getTargetheat(1) > getMaxheat()) {
					setTargetheat(1, getMaxheat());
				}
			}
			break;
		case 3:
			if (getTargetheat(1) >= 0) {
				setTargetheat(1, getTargetheat(1) - 100);
				if (getTargetheat(1) < 0) {
					setTargetheat(1, 0);
				}
			}
			break;
		case 4:
			if (getTargetheat(2) <= getMaxheat()) {
				setTargetheat(2, getTargetheat(2) + 100);
				if (getTargetheat(2) > getMaxheat()) {
					setTargetheat(2, getMaxheat());
				}
			}
			break;
		case 5:
			if (getTargetheat(2) >= 0) {
				setTargetheat(2, getTargetheat(2) - 100);
				if (getTargetheat(2) < 0) {
					setTargetheat(2, 0);
				}
			}
			break;
		case 6:
			if (getTargetheat(3) <= getMaxheat()) {
				setTargetheat(3, getTargetheat(3) + 100);
				if (getTargetheat(3) > getMaxheat()) {
					setTargetheat(3, getMaxheat());
				}
			}
			break;
		case 7:
			if (getTargetheat(3) >= 0) {
				setTargetheat(3, getTargetheat(3) - 100);
				if (getTargetheat(3) < 0) {
					setTargetheat(3, 0);
				}
			}
			break;
		case 8:
			if (getTargetheat(4) <= getMaxheat()) {
				setTargetheat(4, getTargetheat(4) + 100);
				if (getTargetheat(4) > getMaxheat()) {
					setTargetheat(4, getMaxheat());
				}
			}
			break;
		case 9:
			if (getTargetheat(4) >= 0) {
				setTargetheat(4, getTargetheat(4) - 100);
				if (getTargetheat(4) < 0) {
					setTargetheat(4, 0);
				}
			}
			break;
		}
	}

	public TileEntityReaktorMonitor() {

		inventory = new ItemStack[1];
		channel = new boolean[] { false, false, false, false, false, false };
		targetheat = new int[] { 0, 0, 0, 0, 0 };
		RMonitor_ID = 0;
		create = true;
		reaktoraktive = false;

	}

	public int getRMonitor_ID() {
		return RMonitor_ID;
	}

	public void setRMonitor_ID(int rMonitor_ID) {
		RMonitor_ID = rMonitor_ID;
		updateCount++;
	}

	public void freqencoding() {

		if(!worldObj.isRemote) {

			if (getStackInSlot(0) != null) {
				if (getStackInSlot(0).getItem() == mod_AdvancedRepulsionSystems.MFFSitemcardempty && getStackInSlot(0).stackSize == 1) {

					this.setInventorySlotContents(0, new ItemStack(mod_AdvancedRepulsionSystems.MFFSitemsclc));

					Functions.getTAGfromItemstack(getStackInSlot(0)).setInteger("RMonitorID", RMonitor_ID);
					this.onInventoryChanged();
				}
			}
		}
	}

	public void removefromgrid() {

		if(!worldObj.isRemote) {
			Linkgrid.getWorldMap(worldObj).getRMonitor().remove(getRMonitor_ID());
		}
	}

	@Override
	public void updateEntity() {

		super.updateEntity();

		if(!worldObj.isRemote) {

			updatecheck();
			freqencoding();

			if (isIsreaktor()) {

				TileEntity tileEntity = worldObj.getBlockTileEntity(reaktorx, reaktory, reaktorz);

				if (tileEntity == null) {
					setIsreaktor(false);
				}

				if (tileEntity instanceof TileEntityNuclearReactor) {

					heat = ((TileEntityNuclearReactor) tileEntity).heat;
					updateCount++;
					reaktoraktive = ((TileEntityNuclearReactor) tileEntity).getActive();

					if (reaktoraktive != channel[0]) {
						channel[0] = reaktoraktive;
					}

					if (targetheat[0] < heat && channel[1] != true) {
						channel[1] = true;
					}
					if (targetheat[1] < heat && channel[2] != true) {
						channel[2] = true;
					}
					if (targetheat[2] < heat && channel[3] != true) {
						channel[3] = true;
					}
					if (targetheat[3] < heat && channel[4] != true) {
						channel[4] = true;
					}
					if (targetheat[4] < heat && channel[5] != true) {
						channel[5] = true;
					}

					if (targetheat[0] > heat && channel[1] != false) {
						channel[1] = false;
					}
					if (targetheat[1] > heat && channel[2] != false) {
						channel[2] = false;
					}
					if (targetheat[2] > heat && channel[3] != false) {
						channel[3] = false;
					}
					if (targetheat[3] > heat && channel[4] != false) {
						channel[4] = false;
					}
					if (targetheat[4] > heat && channel[5] != false) {
						channel[5] = false;
					}

				}

			} else {

				channel = new boolean[] { false, false, false, false, false, false };
			}

			if (create) {

				if (RMonitor_ID == 0) {

					RMonitor_ID = Linkgrid.getWorldMap(worldObj).newRMonitor_ID(this);

					Montorname_ID = Linkgrid.getWorldMap(worldObj).newRMonitor_Name("");
					Montorname = "Monitor@" + Montorname_ID;

					Linkgrid.getWorldMap(worldObj).getRMonitor().put(getRMonitor_ID(), this);
				} else {
					Linkgrid.getWorldMap(worldObj).getRMonitor().put(getRMonitor_ID(), this);
				}
				create = false;
			}

		}
	}

	@Override
	public void readFromNBT(NBTTagCompound nbttagcompound) {

		super.readFromNBT(nbttagcompound);

		targetheat[0] = nbttagcompound.getInteger("targetheat0");
		targetheat[1] = nbttagcompound.getInteger("targetheat1");
		targetheat[2] = nbttagcompound.getInteger("targetheat2");
		targetheat[3] = nbttagcompound.getInteger("targetheat3");
		targetheat[4] = nbttagcompound.getInteger("targetheat4");

		Montorname_ID = nbttagcompound.getInteger("MontornameID");
		Montorname = nbttagcompound.getString("Montorname");
		RMonitor_ID = nbttagcompound.getInteger("RMonitorID");

		NBTTagList nbttaglist = nbttagcompound.getTagList("Items");
		inventory = new ItemStack[getSizeInventory()];
		for (int i = 0; i < nbttaglist.tagCount(); i++) {
			NBTTagCompound nbttagcompound1 = (NBTTagCompound) nbttaglist.tagAt(i);
			byte byte0 = nbttagcompound1.getByte("Slot");
			if (byte0 >= 0 && byte0 < inventory.length) {
				inventory[byte0] = ItemStack.loadItemStackFromNBT(nbttagcompound1);
			}
		}

	}

	@Override
	public void writeToNBT(NBTTagCompound nbttagcompound) {

		super.writeToNBT(nbttagcompound);

		nbttagcompound.setInteger("targetheat0", targetheat[0]);
		nbttagcompound.setInteger("targetheat1", targetheat[1]);
		nbttagcompound.setInteger("targetheat2", targetheat[2]);
		nbttagcompound.setInteger("targetheat3", targetheat[3]);
		nbttagcompound.setInteger("targetheat4", targetheat[4]);

		nbttagcompound.setInteger("MontornameID", Montorname_ID);
		nbttagcompound.setString("Montorname", Montorname);
		nbttagcompound.setInteger("RMonitorID", RMonitor_ID);

		NBTTagList nbttaglist = new NBTTagList();
		for (int i = 0; i < inventory.length; i++) {
			if (inventory[i] != null) {
				NBTTagCompound nbttagcompound1 = new NBTTagCompound();
				nbttagcompound1.setByte("Slot", (byte) i);
				inventory[i].writeToNBT(nbttagcompound1);
				nbttaglist.appendTag(nbttagcompound1);
			}
		}

		nbttagcompound.setTag("Items", nbttaglist);
	}

	@Override
	public int getSizeInventory() {
		return inventory.length;
	}

	@Override
	public ItemStack getStackInSlot(int i) {
		return inventory[i];
	}

	@Override
	public int getInventoryStackLimit() {
		return 1;
	}

	@Override
	public boolean isUseableByPlayer(EntityPlayer entityplayer) {
		if (worldObj.getBlockTileEntity(xCoord, yCoord, zCoord) != this) {
			return false;
		} else {
			return entityplayer.getDistance((double) xCoord + 0.5D, (double) yCoord + 0.5D, (double) zCoord + 0.5D) <= 64D;
		}
	}

	@Override
	public ItemStack decrStackSize(int i, int j) {
		if (inventory[i] != null) {
			if (inventory[i].stackSize <= j) {
				ItemStack itemstack = inventory[i];
				inventory[i] = null;
				return itemstack;
			}
			ItemStack itemstack1 = inventory[i].splitStack(j);
			if (inventory[i].stackSize == 0) {
				inventory[i] = null;
			}
			return itemstack1;
		} else {
			return null;
		}
	}

	@Override
	public void setInventorySlotContents(int i, ItemStack itemstack) {
		inventory[i] = itemstack;
		if (itemstack != null && itemstack.stackSize > getInventoryStackLimit()) {
			itemstack.stackSize = getInventoryStackLimit();
		}
	}

	@Override
	public void openChest() {

	}

	@Override
	public String getInvName() {

		return "ReaktorMonitor";
	}

	@Override
	public void closeChest() {

	}

	public int getHeat() {
		return heat;
	}

	public void setHeat(int heat) {
		this.heat = heat;
		updateCount++;
	}

	public boolean isIsreaktor() {
		return isreaktor;
	}

	public void setIsreaktor(boolean isreaktor) {
		this.isreaktor = isreaktor;
		updateCount++;
	}

	public int getReaktorx() {
		return reaktorx;
	}

	public void setReaktorx(int reaktorx) {
		this.reaktorx = reaktorx;
	}

	public int getReaktory() {
		return reaktory;
	}

	public void setReaktory(int reaktory) {
		this.reaktory = reaktory;
	}

	public int getReaktorz() {
		return reaktorz;
	}

	public void setReaktorz(int reaktorz) {
		this.reaktorz = reaktorz;
	}

	public boolean isReaktoraktive() {
		return reaktoraktive;
	}

	public boolean getChannel(int stat) {
		return channel[stat];
	}

	public boolean[] getChannel() {
		return channel;
	}

	public int getTargetheat(int channel) {
		return targetheat[channel];
	}

	public void setTargetheat(int channel, int heat) {
		this.targetheat[channel] = heat;
		updateCount++;
	}

	public int getMaxheat() {
		return maxheat;
	}

	public void setMaxheat(int maxheat) {
		this.maxheat = maxheat;
		updateCount++;
	}

	public String getMontorname() {
		return Montorname;
	}

	@Override
	public ItemStack getStackInSlotOnClosing(int var1) {
		return null;
	}

}
