package immibis.ars;

/* $if jclient$ */

import immibis.core.aspects.ClientOnly;
import immibis.core.net.AbstractSyncedContainer;

import net.minecraft.src.EntityPlayer;
import net.minecraft.src.GuiButton;
import net.minecraft.src.GuiContainer;

import org.lwjgl.opengl.GL11;

@ClientOnly
public class GuiReaktorMonitor extends GuiContainer {

	private TileEntityReaktorMonitor Monitor;

	public GuiReaktorMonitor(EntityPlayer inventoryPlayer, TileEntityReaktorMonitor tileentity) {

		super(new ContainerReaktorMonitor(inventoryPlayer, tileentity));
		Monitor = tileentity;

	}
	
	@Override
	protected void actionPerformed(GuiButton guibutton) {
		((AbstractSyncedContainer)inventorySlots).sendButtonPressed(guibutton.id);
	}

	@SuppressWarnings("unchecked")
	@Override
	public void initGui() {

		controlList.add(new GuiButton(0, (width / 2) + 30, (height / 2) - 50, 10, 10, "+"));
		controlList.add(new GuiButton(1, (width / 2) - 20, (height / 2) - 50, 10, 10, "-"));
		controlList.add(new GuiButton(2, (width / 2) + 30, (height / 2) - 35, 10, 10, "+"));
		controlList.add(new GuiButton(3, (width / 2) - 20, (height / 2) - 35, 10, 10, "-"));
		controlList.add(new GuiButton(4, (width / 2) + 30, (height / 2) - 20, 10, 10, "+"));
		controlList.add(new GuiButton(5, (width / 2) - 20, (height / 2) - 20, 10, 10, "-"));
		controlList.add(new GuiButton(6, (width / 2) + 30, (height / 2) - 5, 10, 10, "+"));
		controlList.add(new GuiButton(7, (width / 2) - 20, (height / 2) - 5, 10, 10, "-"));
		controlList.add(new GuiButton(8, (width / 2) + 30, (height / 2) + 10, 10, 10, "+"));
		controlList.add(new GuiButton(9, (width / 2) - 20, (height / 2) + 10, 10, 10, "-"));

		super.initGui();
	}

	@Override
	protected void drawGuiContainerBackgroundLayer(float f, int i, int j) {

		int textur = mc.renderEngine.getTexture("/immibis/ars/textures/GUImonitor.png");
		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
		mc.renderEngine.bindTexture(textur);
		int w = (width - xSize) / 2;
		int k = (height - ySize) / 2;
		drawTexturedModalRect(w, k, 0, 0, xSize, ySize);

	}

	@Override
	/* $if mc < 1.4$
	protected void drawGuiContainerForegroundLayer() {
	$else$ */
	protected void drawGuiContainerForegroundLayer(int par1, int par2) { 
	/* $endif$ */

		fontRenderer.drawString("Reactor monitor", 30, 5, 0x404040);

		fontRenderer.drawString("Channel 0:", 10, 20, 0x404040);
		fontRenderer.drawString("Reactor active", 80, 20, 0x404040);

		fontRenderer.drawString("Channel 1:", 10, 35, 0x404040);
		fontRenderer.drawString((new StringBuilder()).append(" ").append(Monitor.getTargetheat(0)).toString(), 80, 35, 0x404040);
		fontRenderer.drawString("heat", 140, 35, 0x404040);

		fontRenderer.drawString("Channel 2:", 10, 50, 0x404040);
		fontRenderer.drawString((new StringBuilder()).append(" ").append(Monitor.getTargetheat(1)).toString(), 80, 50, 0x404040);
		fontRenderer.drawString("heat", 140, 50, 0x404040);

		fontRenderer.drawString("Channel 3:", 10, 65, 0x404040);
		fontRenderer.drawString((new StringBuilder()).append(" ").append(Monitor.getTargetheat(2)).toString(), 80, 65, 0x404040);
		fontRenderer.drawString("heat", 140, 65, 0x404040);

		fontRenderer.drawString("Channel 4:", 10, 80, 0x404040);
		fontRenderer.drawString((new StringBuilder()).append(" ").append(Monitor.getTargetheat(3)).toString(), 80, 80, 0x404040);
		fontRenderer.drawString("heat", 140, 80, 0x404040);

		fontRenderer.drawString("Channel 5:", 10, 95, 0x404040);
		fontRenderer.drawString((new StringBuilder()).append(" ").append(Monitor.getTargetheat(4)).toString(), 80, 95, 0x404040);
		fontRenderer.drawString("heat", 140, 95, 0x404040);

		fontRenderer.drawString((new StringBuilder()).append(Monitor.getMontorname()).toString(), 10, 110, 0x404040);

		fontRenderer.drawString("Frequency card:", 5, 123, 0x404040);

	}

}

/* $endif$ */
