package immibis.ars;


import ic2.common.TileEntityReactorChamber;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

import net.minecraft.src.forge.*;
import net.minecraftforge.common.*;
import net.minecraft.src.*;

public class BlockUpgrades extends BlockContainer
/* $if mc < 1.3$
	implements ISpecialResistance
$endif$ */
{
	/* $if mc > 1.3$ */
	@Override
	public final void getSubBlocks(int par1, CreativeTabs par2CreativeTabs, List par3List) {
		ArrayList al = new ArrayList();
		addCreativeItems(al);
		par3List.addAll(al);
	}
	/* $endif$ */

	private int blockid;
	
	public static final int META_REACTOR_MONITOR_CLIENT = 0;
	public static final int META_SUBWATER = 1;
	public static final int META_DOME = 2;
	public static final int META_HARDNER = 3;
	public static final int META_CORE_STORAGE = 4;
	public static final int META_CORE_RANGE = 5;
	public static final int META_ZAPPER = 6;
	public static final int META_CAMO = 7;
	public static final int META_REACTOR_CONNECTOR = 8;
	public static final int META_INHIBITOR = 9;
	
	public static final int MAX_META = 10;

	public BlockUpgrades(int i) {

		super(i, Material.iron);
		blockid = i;
		setHardness(3F);
		setResistance(50F);
		setStepSound(soundMetalFootstep);
		
		/* $if mc > 1.3$ */
		setCreativeTab(CreativeTabs.tabMisc);
		/* $endif$ */

	}

	public int getBlockid() {
		return blockid;
	}

	public int getGuiPro(World world, int i, int j, int k, EntityPlayer entityplayer) {
		switch (world.getBlockMetadata(i, j, k)) {
		case 0:
			return mod_AdvancedRepulsionSystems.GUI_ID_GENERATOR;
		case 1:
			return mod_AdvancedRepulsionSystems.GUI_AREA_PROJECTOR;
		case 2:
			return mod_AdvancedRepulsionSystems.GUI_DIRECTIONAL_PROJECTOR;
		case 3:
			return mod_AdvancedRepulsionSystems.GUI_DEFLECTOR_PROJECTOR;
		case 4:
			return mod_AdvancedRepulsionSystems.GUI_TUBE_PROJECTOR;
		case 5:
			return mod_AdvancedRepulsionSystems.GUI_DIRECTIONAL_UPGRADE;
		default:
			return -1;
		}
	}

	public int getGuiUp(World world, int i, int j, int k, EntityPlayer entityplayer) {
		switch (world.getBlockMetadata(i, j, k)) {

		case 0:
			return mod_AdvancedRepulsionSystems.GUI_REACTOR_MONITOR_CLIENT;
		case 7:
			return mod_AdvancedRepulsionSystems.GUI_CAMOFLAGE_UPGRADE;
		default:
			return -1;
		}
	}

	@Override
	/* $if mc < 1.4$
	public boolean isIndirectlyPoweringTo(World world, int i, int j, int k, int l) {
	$else$ */
	public boolean isIndirectlyPoweringTo(IBlockAccess world, int i, int j, int k, int l) {
	/* $endif$ */
		TileEntity tileentity = world.getBlockTileEntity(i, j, k);
		if (tileentity instanceof TileEntityReaktorConnector) {

			if (((TileEntityReaktorConnector) tileentity).isredpowert()) {

				switch (l) {

				case 0:
					if (world.getBlockTileEntity(i, j + 1, k) instanceof TileEntityReactorChamber) {
						return true;
					}

					break;
				case 1:

					if (world.getBlockTileEntity(i, j - 1, k) instanceof TileEntityReactorChamber) {
						return true;
					}

					break;
				case 2:
					if (world.getBlockTileEntity(i, j, k + 1) instanceof TileEntityReactorChamber) {
						return true;
					}
					break;
				case 3:
					if (world.getBlockTileEntity(i, j, k - 1) instanceof TileEntityReactorChamber) {
						return true;
					}

					break;
				case 4:
					if (world.getBlockTileEntity(i + 1, j, k) instanceof TileEntityReactorChamber) {
						return true;
					}
					break;
				case 5:
					if (world.getBlockTileEntity(i - 1, j, k) instanceof TileEntityReactorChamber) {
						return true;
					}
					break;
				default:
					return false;

				}

			}

		}

		if (tileentity instanceof TileEntityReaktorMonitorClient) {
			if (((TileEntityReaktorMonitorClient) tileentity).isSignal()) {
				switch (l) {

				case 0:
					if (world.getBlockTileEntity(i, j + 1, k) instanceof TileEntityReaktorMonitorClient) {
						return false;
					}

					break;
				case 1:

					if (world.getBlockTileEntity(i, j - 1, k) instanceof TileEntityReaktorMonitorClient) {
						return false;
					}

					break;
				case 2:
					if (world.getBlockTileEntity(i, j, k + 1) instanceof TileEntityReaktorMonitorClient) {
						return false;
					}
					break;
				case 3:
					if (world.getBlockTileEntity(i, j, k - 1) instanceof TileEntityReaktorMonitorClient) {
						return false;
					}

					break;
				case 4:
					if (world.getBlockTileEntity(i + 1, j, k) instanceof TileEntityReaktorMonitorClient) {
						return false;
					}
					break;
				case 5:
					if (world.getBlockTileEntity(i - 1, j, k) instanceof TileEntityReaktorMonitorClient) {
						return false;
					}
					break;
				}

				return false;
			}
		}

		return false;
	}

	@Override
	public boolean isPoweringTo(IBlockAccess iblockaccess, int i, int j, int k, int l) {
		TileEntity tileentity = iblockaccess.getBlockTileEntity(i, j, k);
		if (tileentity instanceof TileEntityReaktorConnector) {

			if (((TileEntityReaktorConnector) tileentity).isredpowert()) {

				switch (l) {

				case 0:
					if (iblockaccess.getBlockTileEntity(i, j + 1, k) instanceof TileEntityReactorChamber) {
						return true;
					}

					break;
				case 1:

					if (iblockaccess.getBlockTileEntity(i, j - 1, k) instanceof TileEntityReactorChamber) {
						return true;
					}

					break;
				case 2:
					if (iblockaccess.getBlockTileEntity(i, j, k + 1) instanceof TileEntityReactorChamber) {
						return true;
					}
					break;
				case 3:
					if (iblockaccess.getBlockTileEntity(i, j, k - 1) instanceof TileEntityReactorChamber) {
						return true;
					}

					break;
				case 4:
					if (iblockaccess.getBlockTileEntity(i + 1, j, k) instanceof TileEntityReactorChamber) {
						return true;
					}
					break;
				case 5:
					if (iblockaccess.getBlockTileEntity(i - 1, j, k) instanceof TileEntityReactorChamber) {
						return true;
					}
					break;
				default:
					return false;

				}
			}

			return false;

		}

		if (tileentity instanceof TileEntityReaktorMonitorClient) {
			if (((TileEntityReaktorMonitorClient) tileentity).isSignal()) {

				switch (l) {

				case 0:
					if (iblockaccess.getBlockTileEntity(i, j + 1, k) instanceof TileEntityReaktorMonitorClient) {
						return false;
					}

					break;
				case 1:

					if (iblockaccess.getBlockTileEntity(i, j - 1, k) instanceof TileEntityReaktorMonitorClient) {
						return false;
					}

					break;
				case 2:
					if (iblockaccess.getBlockTileEntity(i, j, k + 1) instanceof TileEntityReaktorMonitorClient) {
						return false;
					}
					break;
				case 3:
					if (iblockaccess.getBlockTileEntity(i, j, k - 1) instanceof TileEntityReaktorMonitorClient) {
						return false;
					}

					break;
				case 4:
					if (iblockaccess.getBlockTileEntity(i + 1, j, k) instanceof TileEntityReaktorMonitorClient) {
						return false;
					}
					break;
				case 5:
					if (iblockaccess.getBlockTileEntity(i - 1, j, k) instanceof TileEntityReaktorMonitorClient) {
						return false;
					}
					break;
				}
				return true;
			}
		}

		return false;
	}

	@Override
	public boolean canProvidePower() {

		return true;
	}

	@Override
	/* $if mc < 1.3$
	public void onBlockRemoval(World world, int i, int j, int k) {
	$else$ */
	public void breakBlock(World world, int i, int j, int k, int par5, int par6) {
	/* $endif$ */
		if(world.isRemote)
			return;

		TileEntity tileentity = world.getBlockTileEntity(i, j, k);
		if (tileentity instanceof TileEntityReaktorMonitorClient) {
			ItemStack itemstack = ((TileEntityReaktorMonitorClient) tileentity).getStackInSlot(0);
			if (itemstack != null) {
				world.spawnEntityInWorld(new EntityItem(world, i + 0.5f, j + 0.5f, k + 0.5f, itemstack));
			}
		}

		world.removeBlockTileEntity(i, j, k);
	}

	@Override
	/* $if mc < 1.3$
	public boolean blockActivated(World world, int i, int j, int k, EntityPlayer entityplayer) {
	$else$ */
	public boolean onBlockActivated(World world, int i, int j, int k, EntityPlayer entityplayer, int par6, float par7, float par8, float par9) {
	/* $endif$ */
	
		int gui = getGuiUp(world, i, j, k, entityplayer);
		int meta = world.getBlockMetadata(i, j, k);

		if (gui < 0 && meta != 4 && meta != 5) {
			return false;
		}

		if (entityplayer.isSneaking())
			return false;

		if (entityplayer.getCurrentEquippedItem() != null && (entityplayer.getCurrentEquippedItem().getItem() instanceof ItemMFD)) {
			return false;
		}

		if (gui >= 0) {
			if(!world.isRemote)
				entityplayer.openGui(mod_AdvancedRepulsionSystems.instance, gui, world, i, j, k);
			return true;
		}

		if (meta == 4 || meta == 5) {
			TileUpgradePassive tileentity = (TileUpgradePassive) world.getBlockTileEntity(i, j, k);
			if (tileentity.getconectet_ID() != 0) {
				TileEntityGeneratorCore tileentitygen = Linkgrid.getWorldMap(world).getGenerator().get(tileentity.getconectet_ID());
				if (tileentitygen != null && !world.isRemote) {
					int guiid = getGuiPro(world, tileentitygen.xCoord, tileentitygen.yCoord, tileentitygen.zCoord, entityplayer);
					if(guiid >= 0)
						entityplayer.openGui(mod_AdvancedRepulsionSystems.instance, gui, world, tileentitygen.xCoord, tileentitygen.yCoord, tileentitygen.zCoord);
				}
			}
		}
		return false;
	}

	@Override
	/* $if mc < 1.3$
	public TileEntityMaschines getBlockEntity() {
	$else$ */
	public TileEntityMaschines createNewTileEntity(World w) {
	/* $endif$ */
		return null;
	}

	@Override
	public int damageDropped(int i) {
		return i;

	}

	@Override
	/* $if mc < 1.3$
	public TileEntityMaschines getBlockEntity(int i) {
	$else$ */
	public TileEntityMaschines createNewTileEntity(World w, int i) {
	/* $endif$ */
		switch (i) {
		case 0:
			return new TileEntityReaktorMonitorClient();
		case 1: // '\\ Projektor Subwater'
		case 2: // '\\ Projektor Dome'
		case 3: // '\\ Projektor Hardner'
		case 4: // '\\ Generator Array'
		case 5: // '\\ Generator Storage'
		case 6: // '\\ Projektor Zapper'
		case META_INHIBITOR:
			return new TileUpgradePassive();
		case 7: // '\\ Projektor camouflage'
			return new TileUpgradeCamouflage();
		case 8: // '\\ Reaktor Connector'
			return new TileEntityReaktorConnector();
		}
		return null;
	}

	@Override
	public String getTextureFile() {

		return "/immibis/ars/textures/upgrades.png";
	}

	public static boolean isActive(IBlockAccess iblockaccess, int i, int j, int k) {
		TileEntity tileentity = iblockaccess.getBlockTileEntity(i, j, k);

		if (tileentity instanceof TileEntityReaktorMonitorClient) {
			if (((TileEntityReaktorMonitorClient) tileentity).isSignal()) {
				return true;
			} else {
				return false;
			}

		}

		if (tileentity instanceof TileUpgradePassive) {
			return ((TileUpgradePassive) tileentity).getconectet_ID() != 0;
		} else {
			return false;
		}
	}

	/* $if jclient$ */
	@Override
	/* $endif$ */
	public int getBlockTexture(IBlockAccess iblockaccess, int i, int j, int k, int l) {
		TileEntity tileentity = iblockaccess.getBlockTileEntity(i, j, k);
		short facing = (tileentity instanceof TileEntityMaschines) ? ((TileEntityMaschines) tileentity).getFacing() : 0;
		int meta = iblockaccess.getBlockMetadata(i, j, k);

		if (isActive(iblockaccess, i, j, k)) {
			if (facing == l) {
				return (meta * 16) + 7;
			}

			return (meta * 16) + 7 + l;

		} else {
			if (facing == l) {
				return (meta * 16);
			}

			return (meta * 16) + l;
		}
	}

	@Override
	public int getBlockTextureFromSideAndMetadata(int i, int j) {

		return (j * 16) + i - 1;
	}

	@Override
	public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
		TileEntity tileentity = world.getBlockTileEntity(i, j, k);
		if (tileentity instanceof TileUpgradePassive) {
			((TileUpgradePassive) tileentity).updatecheck();
		}
	}

	@Override
	/* $if mc >= 1.3$ */
	public float getExplosionResistance(Entity entity, World world, int i, int j, int k, double d, double d1, double d2) {
	/* $else$
	public float getSpecialExplosionResistance(World world, int i, int j, int k, double d, double d1, double d2, Entity entity) {
	$endif$ */
		if (world.getBlockTileEntity(i, j, k) instanceof TileEntityMaschines) {
			TileEntity tileentity = world.getBlockTileEntity(i, j, k);
			if (((TileEntityMaschines) tileentity).getActive()) {
				return 60000F;
			} else {
				return 50F;
			}
		}
		return 50F;
	}
	
	@Override
	public void addCreativeItems(ArrayList l) {
		for(int k = 0; k < MAX_META; k++)
			l.add(new ItemStack(this, 1, k));
	}

}
